package inc.monsters.mias.data;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;

/**
 * The persistent class for the KIDS database table.
 * 
 */
@Entity
@Table(name = "KIDS", schema = "APP")
@NamedQueries( {
		@NamedQuery(name = "Kid.all", query = "SELECT k FROM Kid k"),
		@NamedQuery(name = "Kid.byId", query = "SELECT k FROM Kid k WHERE k.id = :id") })
public class Kid implements Serializable {
	private static final long serialVersionUID = 1L;

	@Id
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private int id;

	@Temporal(TemporalType.DATE)
	@Column(name = "BIRTH_DATE")
	private Date birthDate;

	private double braveness;

	private String comment;

	private String country;

	@Column(name = "FIRST_NAME")
	private String firstName;

	@Column(name = "LAST_NAME")
	private String lastName;

	private String photo;

	@Temporal(TemporalType.DATE)
	@Column(name = "LAST_SCARED")
	private Date lastScared;

	public Kid() {
	}

	public int getId() {
		return this.id;
	}

	public void setId(int id) {
		this.id = id;
	}

	public Date getBirthDate() {
		return this.birthDate;
	}

	public void setBirthDate(Date birthDate) {
		this.birthDate = birthDate;
	}

	public double getBraveness() {
		return this.braveness;
	}

	public void setBraveness(double braveness) {
		this.braveness = braveness;
		setLastScared(new Date());
	}

	public String getComment() {
		return this.comment;
	}

	public void setComment(String comment) {
		this.comment = comment;
	}

	public String getCountry() {
		return this.country;
	}

	public void setCountry(String country) {
		this.country = country;
	}

	public String getFirstName() {
		return this.firstName;
	}

	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}

	public String getLastName() {
		return this.lastName;
	}

	public void setLastName(String lastName) {
		this.lastName = lastName;
	}

	public String getPhoto() {
		return this.photo;
	}

	public void setPhoto(String photo) {
		this.photo = photo;
	}

	public Date getLastScared() {
		return lastScared;
	}

	public void setLastScared(Date lastScared) {
		this.lastScared = lastScared;
	}

	/**
	 * Returns the age (in years) of the Kid. This value is calculated from the
	 * birth date, hence there is no setter for this value.
	 * 
	 * @see Kid#getBirthDate()
	 * @return the age of the Kid.
	 */
	@Transient
	public int getAge() {
		Calendar today = Calendar.getInstance();
		Calendar birth = Calendar.getInstance();
		Date birthDate = getBirthDate();
		if(null == birthDate) {
			return -1;
		}
		birth.setTime(birthDate);

		int age = today.get(Calendar.YEAR) - birth.get(Calendar.YEAR);
		if (today.get(Calendar.DAY_OF_YEAR) < birth.get(Calendar.DAY_OF_YEAR)) {
			age--;
		}

		return age;
	}

}